/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiTextArea;
import noppes.npcs.client.gui.util.IKeyListener;
import noppes.npcs.client.gui.util.IMouseListener;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.client.gui.util.LineData;
import noppes.npcs.client.gui.util.TextContainer;
import noppes.npcs.client.gui.util.UndoData;
import noppes.npcs.config.TrueTypeFont;
import org.lwjgl.input.Mouse;

public class GuiTextArea
extends Gui
implements IComponentGui,
IKeyListener,
IMouseListener,
IGuiTextArea {
    private static final TrueTypeFont font = new TrueTypeFont(new Font(CustomNpcs.FontType, 0, CustomNpcs.FontSize), 1.0f);
    protected TextContainer container = null;
    protected ITextChangeListener listener;
    protected final List<String> hoverText = new ArrayList<String>();
    protected boolean enableCodeHighlighting = false;
    protected int cursorCounter;
    protected int startSelection;
    protected int endSelection;
    protected int cursorPosition;
    protected int scrolledLine = 0;
    protected long lastClicked = 0L;
    public int id;
    public int x;
    public int y;
    public int width;
    public int height;
    public String text = null;
    public boolean active = false;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean clicked = false;
    public boolean doubleClicked = false;
    public boolean clickScrolling = false;
    public List<UndoData> undoList = new ArrayList<UndoData>();
    public List<UndoData> redoList = new ArrayList<UndoData>();
    public boolean undoing = true;
    public boolean hovered = false;
    public boolean freeze = false;
    public int errorLine = -1;

    public GuiTextArea(int id, int x, int y, int width, int height, String label) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setFullText(label);
        font.setSpecial('\uffff');
    }

    private void addText(String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        this.undoList.add(new UndoData(this.text, this.cursorPosition, this.startSelection, this.endSelection, this.scrolledLine));
        if (this.undoList.size() > 100) {
            this.undoList.remove(0);
        }
        this.setFullText(this.getSelectionBeforeText() + s + this.getSelectionAfterText());
        this.cursorPosition = this.endSelection = this.startSelection + s.length();
        this.startSelection = this.endSelection;
    }

    private int cursorDown() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            return this.getSelectionPos(this.x + 1 + font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i + 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return this.text.length();
    }

    private int cursorUp() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            if (i == 0) {
                return 0;
            }
            return this.getSelectionPos(this.x + 1 + font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i - 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return 0;
    }

    @Override
    public void render(IEditNPC gui, int xMouse, int yMouse, float partialTicks) {
        int found;
        if (!this.visible) {
            return;
        }
        boolean bl = this.hovered = xMouse >= this.x && xMouse <= this.x + this.width && yMouse >= this.y && yMouse <= this.y + this.height;
        if (this.hovered && !gui.hasSubGui() && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
        GuiTextArea.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)new Color(-6250336).getRGB());
        GuiTextArea.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)new Color(-16777216).getRGB());
        this.container.visibleLines = this.height / this.container.lineHeight;
        if (!this.freeze) {
            if (this.clicked) {
                this.clicked = Mouse.isButtonDown((int)0);
                int i = this.getSelectionPos(xMouse, yMouse);
                if (i != this.cursorPosition) {
                    if (this.doubleClicked) {
                        this.endSelection = this.cursorPosition;
                        this.startSelection = this.cursorPosition;
                        this.doubleClicked = false;
                    }
                    this.setCursor(i, true);
                }
            } else if (this.doubleClicked) {
                this.doubleClicked = false;
            }
            if (this.clickScrolling) {
                this.clickScrolling = Mouse.isButtonDown((int)0);
                int diff = this.container.linesCount - this.container.visibleLines;
                this.scrolledLine = (int)Math.min(Math.max(1.0f * (float)diff * (float)(yMouse - this.y) / (float)this.height, 0.0f), (float)diff);
            }
        }
        int startBracket = 0;
        int endBracket = 0;
        if ((this.endSelection - this.startSelection == 1 || this.startSelection == this.endSelection && this.startSelection < this.text.length()) && (found = this.getFound()) != 0) {
            startBracket = this.startSelection;
            endBracket = this.startSelection + found;
        }
        try {
            String wordHeightLight = null;
            if (this.startSelection != this.endSelection) {
                Matcher m = this.container.regexWord.matcher(this.text);
                while (m.find()) {
                    if (m.start() != this.startSelection || m.end() != this.endSelection) continue;
                    wordHeightLight = this.text.substring(this.startSelection, this.endSelection);
                }
            }
            ArrayList<LineData> list = new ArrayList<LineData>(this.container.lines);
            if (this.errorLine >= 0) {
                if (this.errorLine >= list.size()) {
                    this.errorLine = list.size() - 1;
                }
                if (this.errorLine >= this.scrolledLine && this.scrolledLine < this.scrolledLine + this.container.visibleLines) {
                    int posY = this.y + 1 + (this.errorLine - this.scrolledLine) * this.container.lineHeight;
                    GuiTextArea.func_73734_a((int)(this.x + 1), (int)posY, (int)(this.x + this.width - 1), (int)(posY + this.container.lineHeight + 1), (int)-1714683904);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            for (int j = 0; j < list.size(); ++j) {
                int posY;
                int e;
                LineData data = (LineData)list.get(j);
                String line = data.text;
                int w = line.length();
                if (startBracket != endBracket) {
                    int s;
                    if (startBracket >= data.start && startBracket < data.end) {
                        s = font.width(line.substring(0, startBracket - data.start));
                        e = font.width(line.substring(0, startBracket - data.start + 1)) + 1;
                        posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                        GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                    }
                    if (endBracket >= data.start && endBracket < data.end) {
                        s = font.width(line.substring(0, endBracket - data.start));
                        e = font.width(line.substring(0, endBracket - data.start + 1)) + 1;
                        posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                        GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                    }
                }
                if (j < this.scrolledLine || j >= this.scrolledLine + this.container.visibleLines) continue;
                if (wordHeightLight != null) {
                    Matcher k = this.container.regexWord.matcher(line);
                    while (k.find()) {
                        if (!line.substring(k.start(), k.end()).equals(wordHeightLight)) continue;
                        int s2 = font.width(line.substring(0, k.start()));
                        int e2 = font.width(line.substring(0, k.end())) + 1;
                        int posY2 = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                        GuiTextArea.func_73734_a((int)(this.x + 1 + s2), (int)posY2, (int)(this.x + 1 + e2), (int)(posY2 + this.container.lineHeight + 1), (int)-1728033792);
                    }
                }
                if (j != this.errorLine && this.startSelection != this.endSelection && this.endSelection > data.start && this.startSelection <= data.end && this.startSelection < data.end) {
                    int s = font.width(line.substring(0, Math.max(this.startSelection - data.start, 0)));
                    e = font.width(line.substring(0, Math.min(this.endSelection - data.start, w))) + 1;
                    posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                    GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728052993);
                }
                int yPos = this.y + (j - this.scrolledLine) * this.container.lineHeight + 1;
                font.draw(data.getFormattedString(this.container.makeup), this.x + 1, yPos, -2039584);
                if (!this.active || !this.isEnabled() || this.cursorCounter / 6 % 2 != 0) continue;
                if (this.cursorPosition >= data.start && this.cursorPosition < data.end) {
                    int posX = this.x + font.width(line.substring(0, this.cursorPosition - data.start));
                    GuiTextArea.func_73734_a((int)(posX + 1), (int)yPos, (int)(posX + 2), (int)(yPos + 1 + this.container.lineHeight), (int)-3092272);
                    continue;
                }
                if (j != list.size() - 1 || this.cursorPosition != this.text.length()) continue;
                yPos = this.y + (j - this.scrolledLine) * this.container.lineHeight + 1;
                GuiTextArea.func_73734_a((int)(this.x + 1), (int)yPos, (int)(this.x + 2), (int)(yPos + 1 + this.container.lineHeight), (int)-3092272);
            }
            GlStateManager.func_179121_F();
            if (this.hasVerticalScrollbar()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiCustomScroll.resource);
                int sbSize = (int)Math.max(1.0f * (float)this.container.visibleLines / (float)this.container.linesCount * (float)this.height, 2.0f);
                int posX2 = this.x + this.width - 6;
                int posY3 = (int)((float)this.y + 1.0f * (float)this.scrolledLine / (float)this.container.linesCount * (float)(this.height - 4) + 1.0f);
                GuiTextArea.func_73734_a((int)posX2, (int)posY3, (int)(posX2 + 5), (int)(posY3 + sbSize), (int)-2039584);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getFound() {
        char c = this.text.charAt(this.startSelection);
        int found = 0;
        if (c == '{') {
            found = this.findClosingBracket(this.text.substring(this.startSelection), '{', '}');
        } else if (c == '[') {
            found = this.findClosingBracket(this.text.substring(this.startSelection), '[', ']');
        } else if (c == '(') {
            found = this.findClosingBracket(this.text.substring(this.startSelection), '(', ')');
        } else if (c == '}') {
            found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '{', '}');
        } else if (c == ']') {
            found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '[', ']');
        } else if (c == ')') {
            found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '(', ')');
        }
        return found;
    }

    public void enableCodeHighlighting() {
        this.enableCodeHighlighting = true;
        this.container.setLighting(true);
    }

    private int findClosingBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == s) {
                ++found;
                continue;
            }
            if (c != e || --found != 0) continue;
            return i;
        }
        return 0;
    }

    private int findOpeningBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            char c = chars[i];
            if (c == e) {
                ++found;
                continue;
            }
            if (c != s || --found != 0) continue;
            return i - chars.length + 1;
        }
        return 0;
    }

    public String getSelectionAfterText() {
        return this.text.substring(this.endSelection);
    }

    public String getSelectionBeforeText() {
        if (this.startSelection == 0) {
            return "";
        }
        return this.text.substring(0, this.startSelection);
    }

    private int getSelectionPos(int xMouse, int yMouse) {
        xMouse -= this.x + 1;
        yMouse -= this.y + 1;
        ArrayList<LineData> list = new ArrayList<LineData>(this.container.lines);
        for (int i = 0; i < list.size(); ++i) {
            int yPos;
            LineData data = (LineData)list.get(i);
            if (i < this.scrolledLine || i >= this.scrolledLine + this.container.visibleLines || yMouse < (yPos = (i - this.scrolledLine) * this.container.lineHeight) || yMouse >= yPos + this.container.lineHeight) continue;
            int lineWidth = 0;
            char[] chars = data.text.toCharArray();
            for (int j = 1; j <= chars.length; ++j) {
                int w = font.width(data.text.substring(0, j));
                if (xMouse < lineWidth + (w - lineWidth) / 2) {
                    return data.start + j - 1;
                }
                lineWidth = w;
            }
            return data.end - 1;
        }
        return this.container.text.length();
    }

    @Override
    public void setFocus(boolean bo) {
    }

    @Override
    public String getFullText() {
        return this.text;
    }

    @Override
    public void unFocus() {
    }

    public boolean hasVerticalScrollbar() {
        return this.container.visibleLines < this.container.linesCount;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.visible;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    public void keyTyped(char c, int i) {
        if (!this.active) {
            return;
        }
        if (GuiScreen.func_175278_g((int)i)) {
            int n;
            this.cursorPosition = n = 0;
            this.startSelection = n;
            this.endSelection = this.text.length();
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (i == 203) {
            int j = 1;
            if (GuiScreen.func_146271_m()) {
                Matcher m = this.container.regexWord.matcher(this.text.substring(0, this.cursorPosition));
                while (m.find()) {
                    if (m.start() == m.end()) continue;
                    j = this.cursorPosition - m.start();
                }
            }
            this.setCursor(this.cursorPosition - j, GuiScreen.func_146272_n());
            return;
        }
        if (i == 205) {
            Matcher m;
            int j = 1;
            if (GuiScreen.func_146271_m() && ((m = this.container.regexWord.matcher(this.text.substring(this.cursorPosition))).find() && m.start() > 0 || m.find())) {
                j = m.start();
            }
            this.setCursor(this.cursorPosition + j, GuiScreen.func_146272_n());
            return;
        }
        if (i == 200) {
            this.setCursor(this.cursorUp(), GuiScreen.func_146272_n());
            return;
        }
        if (i == 208) {
            this.setCursor(this.cursorDown(), GuiScreen.func_146272_n());
            return;
        }
        if (i == 211) {
            int startSelection;
            String s = this.getSelectionAfterText();
            if (!s.isEmpty() && this.startSelection == this.endSelection) {
                s = s.substring(1);
            }
            this.setFullText(this.getSelectionBeforeText() + s);
            this.cursorPosition = startSelection = this.startSelection;
            this.endSelection = startSelection;
            return;
        }
        if (i == 14) {
            String s = this.getSelectionBeforeText();
            if (this.startSelection > 0 && this.startSelection == this.endSelection) {
                s = s.substring(0, s.length() - 1);
                --this.startSelection;
            }
            this.setFullText(s + this.getSelectionAfterText());
            this.cursorPosition = this.startSelection;
            this.endSelection = this.startSelection;
            return;
        }
        if (GuiScreen.func_175277_d((int)i)) {
            if (this.startSelection != this.endSelection) {
                int length;
                NoppesStringUtils.setClipboardContents(this.text.substring(this.startSelection, this.endSelection));
                String s = this.getSelectionBeforeText();
                this.setFullText(s + this.getSelectionAfterText());
                this.cursorPosition = length = s.length();
                this.startSelection = length;
                this.endSelection = length;
            }
            return;
        }
        if (GuiScreen.func_175280_f((int)i)) {
            if (this.startSelection != this.endSelection) {
                NoppesStringUtils.setClipboardContents(this.text.substring(this.startSelection, this.endSelection));
            }
            return;
        }
        if (GuiScreen.func_175279_e((int)i)) {
            this.addText(NoppesStringUtils.getClipboardContents());
            return;
        }
        if (i == 44 && GuiScreen.func_146271_m()) {
            if (this.undoList.isEmpty()) {
                return;
            }
            this.redoList.add(new UndoData(this.text, this.cursorPosition, this.startSelection, this.endSelection, this.scrolledLine));
            this.setUndoData(this.undoList.remove(this.undoList.size() - 1));
        }
        if (i == 21 && GuiScreen.func_146271_m()) {
            if (this.redoList.isEmpty()) {
                return;
            }
            this.undoList.add(new UndoData(this.text, this.cursorPosition, this.startSelection, this.endSelection, this.scrolledLine));
            if (this.undoList.size() > 100) {
                this.undoList.remove(0);
            }
            this.setUndoData(this.redoList.remove(this.redoList.size() - 1));
            return;
        }
        if (i == 15) {
            this.addText("\t");
        }
        if (i == 28) {
            this.addText('\n' + this.getIndentCurrentLine());
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.addText(Character.toString(c));
        }
    }

    private void setUndoData(UndoData data) {
        this.undoing = true;
        this.setFullText(data.text);
        this.undoing = false;
        this.cursorPosition = data.cursorPosition;
        this.startSelection = data.startSelection;
        this.endSelection = data.endSelection;
    }

    private String getIndentCurrentLine() {
        for (LineData data : this.container.lines) {
            int i;
            if (this.cursorPosition <= data.start || this.cursorPosition > data.end) continue;
            for (i = 0; i < data.text.length() && data.text.charAt(i) == ' '; ++i) {
            }
            return data.text.substring(0, i);
        }
        return "";
    }

    @Override
    public boolean mouseClicked(int xMouse, int yMouse, int mouseButton) {
        if (this.freeze) {
            return false;
        }
        boolean bl = this.active = xMouse >= this.x && xMouse < this.x + this.width && yMouse >= this.y && yMouse < this.y + this.height;
        if (this.active) {
            int selectionPos;
            this.cursorPosition = selectionPos = this.getSelectionPos(xMouse, yMouse);
            this.endSelection = selectionPos;
            this.startSelection = selectionPos;
            this.clicked = mouseButton == 0;
            this.doubleClicked = false;
            long time = System.currentTimeMillis();
            if (this.clicked && this.container.linesCount * this.container.lineHeight > this.height && xMouse > this.x + this.width - 8) {
                this.clicked = false;
                this.clickScrolling = true;
            } else if (time - this.lastClicked < 500L) {
                this.doubleClicked = true;
                Matcher m = this.container.regexWord.matcher(this.text);
                while (m.find()) {
                    if (this.cursorPosition <= m.start() || this.cursorPosition >= m.end()) continue;
                    this.startSelection = m.start();
                    this.endSelection = m.end();
                    break;
                }
            }
            this.lastClicked = time;
        }
        return this.active;
    }

    private void setCursor(int i, boolean select) {
        if ((i = Math.min(Math.max(i, 0), this.text.length())) == this.cursorPosition) {
            return;
        }
        if (!select) {
            this.cursorPosition = i;
            this.startSelection = i;
            this.endSelection = i;
            return;
        }
        int diff = this.cursorPosition - i;
        if (this.cursorPosition == this.startSelection) {
            this.startSelection -= diff;
        } else if (this.cursorPosition == this.endSelection) {
            this.endSelection -= diff;
        }
        if (this.startSelection > this.endSelection) {
            int j = this.endSelection;
            this.endSelection = this.startSelection;
            this.startSelection = j;
        }
        this.cursorPosition = i;
    }

    public void setListener(ITextChangeListener gui) {
        this.listener = gui;
    }

    @Override
    public void setFullText(String newText) {
        CustomNpcs.debugData.start(null);
        newText = newText.replace("\r", "");
        if (this.text != null && this.text.equals(newText)) {
            return;
        }
        if (this.listener != null) {
            this.listener.textUpdate(newText);
        }
        if (!this.undoing && this.container != null) {
            this.undoList.add(new UndoData(this.text, this.cursorPosition, this.startSelection, this.endSelection, this.scrolledLine));
        }
        if (this.undoList.size() > 100) {
            this.undoList.remove(0);
        }
        this.text = newText;
        this.container = new TextContainer(newText, font, this.width, this.height, this.enableCodeHighlighting);
        this.container.init();
        if (this.scrolledLine > this.container.linesCount - this.container.visibleLines) {
            this.scrolledLine = Math.max(0, this.container.linesCount - this.container.visibleLines);
        }
        CustomNpcs.debugData.end(null);
    }

    @Override
    public int getInteger() {
        return 0;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public long getDefault() {
        return 0L;
    }

    @Override
    public double getDoubleDefault() {
        return 0.0;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void setMinMaxDefault(long minValue, long maxValue, long defaultValue) {
    }

    @Override
    public boolean isLatinAlphabetOnly() {
        return false;
    }

    @Override
    public void setLatinAlphabetOnly(boolean latinAlphabetOnly) {
    }

    @Override
    public void setMinMaxDoubleDefault(double minValue, double maxValue, double defaultValue) {
    }

    @Override
    public boolean isAllowUppercase() {
        return false;
    }

    @Override
    public void setAllowUppercase(boolean allowUppercase) {
    }

    @Override
    public long getMax() {
        return 0L;
    }

    @Override
    public long getMin() {
        return 0L;
    }

    @Override
    public double getDoubleMax() {
        return 0.0;
    }

    @Override
    public double getDoubleMin() {
        return 0.0;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.x + this.width / 2, this.y + this.height / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.x;
    }

    @Override
    public int getTop() {
        return this.y;
    }

    @Override
    public void setLeft(int left) {
        this.x = left;
    }

    @Override
    public void setTop(int top) {
        this.y = top;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void customKeyTyped(char c, int id) {
        this.keyTyped(c, id);
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.visible = bo;
    }

    public void updateScreen() {
        ++this.cursorCounter;
        if (this.freeze) {
            return;
        }
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            this.scrolledLine += dWheel > 0 ? -1 : 1;
            this.scrolledLine = Math.max(Math.min(this.scrolledLine, this.container.linesCount - this.height / this.container.lineHeight), 0);
        }
    }
}

